//
//  OPJSONWebKey.h
//  ApplicationFrameworks
//
//  Created by Rick Fillion on 2015-03-18.
//
//

#import <Foundation/Foundation.h>

// Dictionary Keys
FOUNDATION_EXPORT NSString * const OPJSONWebKeyKeyType;
FOUNDATION_EXPORT NSString * const OPJSONWebKeyUse;
FOUNDATION_EXPORT NSString * const OPJSONWebKeyKeyOperations;
FOUNDATION_EXPORT NSString * const OPJSONWebKeyAlgorithm;
FOUNDATION_EXPORT NSString * const OPJSONWebKeyKeyID;
FOUNDATION_EXPORT NSString * const OPJSONWebKeyKeyPairUUID;
FOUNDATION_EXPORT NSString * const OPJSONWebKeyExt;
FOUNDATION_EXPORT NSString * const OPJSONWebRawKey;
FOUNDATION_EXPORT NSString * const OPJSONWebKeyIterationCount;
FOUNDATION_EXPORT NSString * const OPJSONWebKeySaltInput;
FOUNDATION_EXPORT NSString * const OPJSONWebKeyEncryption;


FOUNDATION_EXPORT NSString * const OPJSONWebKeySymKey;
FOUNDATION_EXPORT NSString * const OPJSONWebKeyKeyPair;
FOUNDATION_EXPORT NSString * const OPJSONWebKeyPubKey;
FOUNDATION_EXPORT NSString * const OPJSONWebKeyPriKey;

// Use
FOUNDATION_EXPORT NSString * const OPJSONWebKeyUseSignature;
FOUNDATION_EXPORT NSString * const OPJSONWebKeyUseEncryption;

// Key Operations
FOUNDATION_EXPORT NSString * const OPJSONWebKeyOperationSign;
FOUNDATION_EXPORT NSString * const OPJSONWebKeyOperationVerify;
FOUNDATION_EXPORT NSString * const OPJSONWebKeyOperationEncrypt;
FOUNDATION_EXPORT NSString * const OPJSONWebKeyOperationDecrypt;
FOUNDATION_EXPORT NSString * const OPJSONWebKeyOperationWrapKey;
FOUNDATION_EXPORT NSString * const OPJSONWebKeyOperationUnwrapKey;
FOUNDATION_EXPORT NSString * const OPJSONWebKeyOperationDeriveKey;
FOUNDATION_EXPORT NSString * const OPJSONWebKeyOperationDeriveBits;

// Encrypted Content
FOUNDATION_EXPORT NSString * const OPJSONWebKeyIDMasterPassword;
FOUNDATION_EXPORT NSString * const OPJSONWebKeyContentType;
FOUNDATION_EXPORT NSString * const OPJSONWebKeyIV;
FOUNDATION_EXPORT NSString * const OPJSONWebKeyData;
FOUNDATION_EXPORT NSString * const OPJSONContentTypeB5;


@interface OPJSONWebKey : NSObject

+ (instancetype)JSONWebKeyFromData:(NSData *)data; // UTF-8 string data
+ (instancetype)JSONWebKeyFromJSONString:(NSString *)string; // @"{...}"
+ (instancetype)JSONWebKeyFromDictionary:(NSDictionary *)object; // @{..}

@property (nonatomic, readonly, copy) NSDictionary *dictionaryRepresentation;

@property (readonly) NSString *keyType;
@property (readonly) NSString *publicKeyUse;
@property (readonly) NSArray *keyOperations;
@property (readonly) NSString *algorithm;
@property (readonly) NSString *keyID;


@end
